//	Maze4DScreenshots.swift
//
//	© 2025 by Jeff Weeks
//	See TermsOfUse.txt

import SwiftUI


//	Set gGetScreenshotOrientations to true while looking
//	for an aesthetically pleasing orientation for each type of screenshot.
//	Copy your preferred orientations into gAppStoreScreenshotData,
//	and then set gGetScreenshotOrientations back to false
//	before making the screenshots.
//#warning("disable gGetScreenshotOrientations")
let gGetScreenshotOrientations = false

//	To make app store screenshots, set gMakeScreenshots to true.
//	In addition, go to the Info.plist file and set
//
//		View controller-based status bar appearance = NO
//		Status bar is initially hidden = YES
//
//	and then restore at least the first one to YES after making the screenshots.
//
//		Note: Somehow CrystalFlight seems to show and hide
//		the status bar using only the SwiftUI modifier
//			.statusBar(hidden: gMakeScreenshots)
//		but I can't figure out what settings are different here
//		and why the same technique doesn't work here.
//
//#warning("restore status bar visibility after making screenshots")
//#warning("disable gMakeScreenshots")
let gMakeScreenshots = false
#if os(iOS)
  let gFirstScreenshotIndex = 0 // to create language-independent screenshots
//let gFirstScreenshotIndex = 2 // to create language-dependent screenshots
#endif
#if os(macOS)
	//	On macOS all the screenshots are language-dependent because
	//	they all have the app's localized name in their title bar.
let gFirstScreenshotIndex = 0
#endif

//	I haven't yet implemented gMakeIcon
//	in this SwiftUI version of 4D Maze.


func prepareForAppStoreScreenshot(
	_ screenshotIndex: Int,
	modelData: Maze4DModel,
	activePanel: Binding<PanelType>,
	optionalRenderer: Maze4DRenderer?
) {
	let theScreenshotData = gAppStoreScreenshotData[screenshotIndex]
	
	modelData.itsMaze = theScreenshotData.maze
	optionalRenderer?.refreshForNewMaze(modelData: modelData)
	
	modelData.itsOrientation = theScreenshotData.orientation

	modelData.changeCount += 1

	activePanel.wrappedValue = theScreenshotData.panel
}


struct ScreenshotData {
	let maze: MazeData
	let orientation: simd_quatd
	let panel: PanelType
}

private let gScreenshot0 = ScreenshotData(
	maze: MazeData(
		difficultyLevel: .hard,
		edges:
		[
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, true, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, true, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, true, false, false])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, true, false])
		   ]
		  ]
		 ]
		],
		sliderPosition: .onOutboundEdge(
							baseNodeIndex: MazeNodeIndex(2,0,0,0),
							direction: 2,
							distance: 0.42),
		goalPosition: MazeNodeIndex(1,0,0,2)
	),
	orientation: simd_quatd(
		real: -0.6349114425869031,
		imag: SIMD3<Double>(-0.3016119477137186, -0.47571667888468494, -0.5287828803010556)),
	panel: .noPanel
)

private let gScreenshot1 = ScreenshotData(
	maze: MazeData(
		difficultyLevel: .extraHard,
		edges:
		[
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [true, true, true, false],
				inbound:  [false, true, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, true])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, true, true],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, true, true],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, true, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, true, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [true, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [true, true, false, true],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, true, false]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, true, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ]
		 ]
		],
		sliderPosition: .onOutboundEdge(
							baseNodeIndex: MazeNodeIndex(0,1,2,2),
							direction: 1,
							distance: 0.25),
		goalPosition: MazeNodeIndex(1,2,3,3)
	),
	orientation: simd_quatd(
		real: -0.10754163202779747,
		imag: SIMD3<Double>(0.7038020386284204, -0.591053501423582, 0.3791480532169472)),
	panel: .noPanel
)

private let gScreenshot2 = ScreenshotData(
	maze: MazeData(
		difficultyLevel: .hard,
		edges:
		[
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, true, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, true, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [true, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, true]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, true, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, true, true])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, true, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ]
		  ]
		 ]
		],
		sliderPosition: .onOutboundEdge(
							baseNodeIndex: MazeNodeIndex(1,0,0,2),
							direction: 2,
							distance: 0.50),
		goalPosition: MazeNodeIndex(1,2,2,0)
	),
	orientation: simd_quatd(
		real: 0.5829837294763893,
		imag: SIMD3<Double>(0.4032221371709437, 0.5791003051579869, 0.402721635657961)),
	panel: .newMazePanel
)

private let gScreenshot3 = ScreenshotData(
	maze: MazeData(
		difficultyLevel: .hard,
		edges:
		[
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, true, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, true, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [false, false, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, true, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, true, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, true]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, true, false, false],
				inbound:  [true, true, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, false, false])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [true, false, false, true],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [true, false, false, false],
				inbound:  [false, true, false, false])
		   ]
		  ]
		 ],
		 [
		  [
		   [
			MazeNodeEdges(
				outbound: [false, true, true, true],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, true],
				inbound:  [false, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, false, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, true, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [true, false, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [true, false, true, false]),
			MazeNodeEdges(
				outbound: [false, true, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, true, true, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, true, false]),
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, false, true, true])
		   ]
		  ],
		  [
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [false, true, false, false])
		   ],
		   [
			MazeNodeEdges(
				outbound: [false, false, false, true],
				inbound:  [true, false, false, false]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, true]),
			MazeNodeEdges(
				outbound: [false, false, false, false],
				inbound:  [true, false, false, false])
		   ]
		  ]
		 ]
		],
		sliderPosition: .onOutboundEdge(
							baseNodeIndex: MazeNodeIndex(1,1,2,1),
							direction: 0,
							distance: 0.50),
		goalPosition: MazeNodeIndex(0,0,2,2)
	),
	orientation: simd_quatd(
		real: -0.48932604576830707,
		imag: SIMD3<Double>(0.5091793641663303, 0.4309967613533684, -0.5617278591478546)),
	panel: .helpPanel
)

private let gAppStoreScreenshotData: [ScreenshotData] = [
	gScreenshot0,
	gScreenshot1,
	gScreenshot2,
	gScreenshot3
]
let gNumAppStoreScreenshots = gAppStoreScreenshotData.count
